const express = require('express')
const app = express()
const shell = require('shelljs')
const cron = require('node-cron');
const cronOne = require('node-cron');

const cronSpeed = require('node-cron');
const shellExec = require('shell-exec')
var decimalPointRegex = /\-?\d+\.\d+/g;
let fs = require('fs')
let port = 5
let secret='0'
let domain='0'
let combineSecret=''


let countReboot = 4
let tryFail = 0

app.get('/', (req, res) => {
    res.send('Hello World!')
    run()
})

app.get('/ip/:ip/', (req, res) => {
    // console.log(req.params.acc)
    return addNewIp(req, res)

})

app.get('/rst2', (req, res) => {

    return reboot()

})

app.get('/test', (req, res) => {
    // console.log(req.params.acc)
    res.sendfile('jetmtp.png')

})

async function addNewIp(req, res) {
    res.send('Hello World!')
    console.log(req.params.ip)
    addBaship(req.params.ip)
}

async function addBaship(ip) {
    return await shell.exec(' ip addr add ' + ip + ' dev eth0').stderr;

}


async function reboot() {
  //  return await shell.exec(' sudo reboot ').stderr;

}

app.listen(3000, () => console.log(`Example app listening on port 3000!`))


async function run() {
    let whiteIp = await getWhiteIp()
    doIptable(whiteIp)
    let data = await getPort()
    console.log(data)
    portRes=parseInt(data.port)
    console.log(portRes)
    if (portRes === 0 || portRes === 443 || portRes ===5) {
        port = randomInt(4000, 60000)
        secret=await shellExec('head -c 16 /dev/urandom | xxd -ps')
        secret=secret.stdout.replace('\n','')
        domain=makedomain()
        combineSecret=getTlsSecret(domain,secret)
        
    }
    else {
        port = parseInt(data.port)
        combineSecret=data.secret
        let d=parse(combineSecret)
        domain=d.domain
        secret=d.secret
        
    }
    let a = await shell.exec('cd .. &&  cd mt  && sudo ./server1.sh ' + port +' '+domain +' ' + secret, {silent: true}).stdout;
    console.log('Reset Proxy')
}


async function doIptable(whiteIp) {
    let command = ''
    for (let i = 0; i < whiteIp.length; i++) {
        command += 'iptables -A INPUT -p tcp -s ' + whiteIp[i] + ' --dport 3000 -j ACCEPT'
        command += '\n'


    }

    command += 'iptables -A INPUT -p tcp -s 0.0.0.0/0 --dport 3000 -j DROP'
    command += '\n'

    await createfile(command)
    await execLast()
    return true
}

function createfile(command) {
    return new Promise(function (resolve, reject) {
        fs.writeFile("iptable.sh", command, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(command);
        });
    });
}

async function execLast() {
    let d = await shellExec('sudo ./iptable.sh')
    return true
}

async function checkProcessWork() {
    let a = await shell.exec('nc -vz 127.0.0.1 ' + port).stderr;
    if (a.includes('succeeded') || a.includes('Connected')) {
        tryFail = 0
        return true

    }
    tryFail++
    if (tryFail >= countReboot)

        reboot()


    run()
}

function randomInt(low, high) {
    return Math.floor(Math.random() * (high - low) + low)
}

cron.schedule('*/50 * * * * *', () => {

    checkProcessWork()
});


async function calculateSpeed() {


    let d = await shellExec('vnstat -tr')
    d = d.stdout

    let arr = d.match(decimalPointRegex)


    if (d.includes('kbit/s')) {
        arr[0] = 1
        arr[1] = 1
    } else if (d.includes('Mbit/s')) {

    } else if (d.includes('Gbit/s')) {
        arr[0] = arr[0] * 1000
        arr[1] = arr[1] * 1000
    } else if (d.includes('bit/s')) {
        arr[0] = 1
        arr[1] = 1
    }


    await sendRate(arr[0], arr[1])


}


function sendRate(rx, tx) {
    const request = require('request');
    if (port ===5)
        return
    let url = 'http://116.202.97.73:3000/rateWithPortAdv/' + rx + '/' + tx + '/' + port +'/'+combineSecret
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 6000}, function (error, res, body) {
            resolve(true)

        });
    });

}


function getPort() {
    const request = require('request');
    let url = 'http://116.202.97.73:3000/getPortAdv2'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(JSON.parse(body))

        });
    });

}

function getWhiteIp() {
    const request = require('request');
    let url = 'http://116.202.97.73:3000/getWhiteIp'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(JSON.parse(body))

        });
    });

}


cronSpeed.schedule(' */5 * * * * *', () => {

    return calculateSpeed()

});


function getTlsSecret(domain,secret)
{
    var domain_bytes = Array.from(domain).map( (c) => c.charCodeAt(0) );
    var tls_bytes = hexToBytes("ee" + secret).concat(domain_bytes);
    return encodeURIComponent(bytesToHex(tls_bytes))
}

function parse(url) {
    url='https://t.me/proxy?server=168.119.96.20&port=443&secret='+url
    var p = url.split("://");
    var proto = p[0];
    if (!(proto == "tg" || proto == "https")) {
        alert("invalid URL protocol: " + proto);
        return false
    };
    p = p[1].split("?");
    var host_or_path = p[0];
    if (proto == "tg" && host_or_path != "proxy") {
        alert("invalid path: " + host_or_path);
        return false
    } else if (proto == "https" && host_or_path != "t.me/proxy") {
        alert("invalid path: " + host_or_path);
        return false
    }
    var query = parseQuery(p[1]);
    var missing = ["server", "port", "secret"].filter(
        (field) => !query.hasOwnProperty(field));
    if (missing.length) {
        alert("Missing: " + missing);
        return false
    }
    var s = query.secret;
    var hex_secret, protocol, tls_domain = "";
    if (s.length == 32 && is_hex(s)) {
        protocol = "Normal";
        hex_secret = s
    } else if (s.length == 34 && s.startsWith("dd") && is_hex(s)) {
        protocol = "Secure";
        hex_secret = s.slice(-32)
    } else if (s.length > 34 && s.startsWith("ee") && is_hex(s)) {
        protocol = "Fake-TLS, hex secret";
        hex_secret = s.slice(2, 34);
        tls_domain = String.fromCharCode.apply(null, hexToBytes(s.slice(34)))
    } else if (s.startsWith("7")) {
        protocol = "Fake-TLS";
        var bin_secret;
        if(/^[0-9a-zA-Z_=-]+$/.test(s)) { // urlsafe base64
            bin_secret = urlSafeBase64ToBytes(s)
            protocol += ", URL-safe base64 secret"
        } else if (/^[0-9a-zA-Z\+\/=]+$/.test(s)) { // normal base64
            bin_secret = base64ToBytes(s)
            protocol += ", base64 sectet"
        } else {
            alert("Invalid secret: " + s);
            return false
        }
        hex_secret = bytesToHex(
            Array.from(bin_secret.slice(1, 17), c => c.charCodeAt(0)));
        tls_domain = bin_secret.slice(17)
    } else {
        alert("Invalid secret: " + s)
    }
    return {protocol: protocol,
        server: query.server,
        port: query.port,
        secret: hex_secret,
        domain: tls_domain}
}

function parseQuery(queryString) {
    var query = {};
    var pairs = queryString.split('&');
    for (var i = 0; i < pairs.length; i++) {
        var pair = pairs[i].split('=');
        query[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1] || '');
    }
    return query;
}
function base64ToBytes(str) {
    return atob(str);
}

function bytesToHex(bytes) {

    for (var hex = [], i = 0; i < bytes.length; i++) {
        var current = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
        hex.push((current >>> 4).toString(16));
        hex.push((current & 0xF).toString(16));
    }
    return hex.join("");
}

function hexToBytes(hex) {
    for (var bytes = [], c = 0; c < hex.length; c += 2)
        bytes.push(parseInt(hex.substr(c, 2), 16));
    return bytes;
}

function makedomain() {
    let length=randomInt(5, 8)
    var result = '';
    var characters = 'abcdefghijklmnopqrstuvwxyz';
    var charactersLength = characters.length;
    for (var i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result+'.com';
}


