const isReachable = require('is-reachable');
var ps = require('ps-node');
const cron = require('node-cron');

var shell = require('shelljs');
const request = require('request');
const cryptLib = require('@skavinvarnan/cryptlib');
const key = "6*sN_rZxHD4!X$=T";
let moment = require('moment-timezone')
let io = require('socket.io-client')
// var chat = io.connect('http://admin.fcfglobal.co:3000')
let ips = []
const fs = require('fs')
let scanner = ''
let trys = 2


async function run() {
    try {
        console.log('Test Mock Server')
        let res = await testIp({ip: '116.202.97.73', ipdate: '0', id: 0, retry: 0})
        if (res.alive)
        {
            console.log(" Work Mock Server")
        }

        else
        {
            console.log("Doenst WOrk Mock Server!!!! Try Again")
            return run()
        }

        console.log("Try Get ips")
        scanner = await fs.readFileSync('./id.txt', 'utf8');
        let proxies
        try {
            proxies = await getAllNeedCheckProxy()
            trys = proxies.try
            proxies = proxies.proxy
            console.log('try:' + trys)
            console.log(proxies.length)

        } catch (e) {
            console.log(e)
            return run()

        }

        let split = 10000
        let allData = []
        let i = (proxies.length / split) + 1
        for (let z = 1; z <= i; z++) {
            let end = z * split
            let start = end - split
            let arr = []
            for (let s = start; s < end; s++) {
                try {
                    if (s >= proxies.length)
                        continue


                    // arr.push(isIpAlive(proxies[s]))

                    arr.push(isIpAlive(proxies[s]))


                } catch (e) {

                }
            }

            let d = await Promise.all(arr)
            for (let i = 0; i < d.length; i++) {


                if (!d[i].alive) {
                    let need = needSend(d[i].ip, 1, d[i].ipdate)
                    if (need) {
                        allData.push(d[i])
                        needSend(d[i].ip, -1, d[i].ipdate)
                    }

                } else
                    needSend(d[i].ip, -1, d[i].ipdate)
            }


        }
        console.log(allData)
        console.log('Try Send ' + allData.length + ' Ips')
        await sendAll(allData)


        return run()

    } catch (e) {
        console.log(e)
        return run()

    }


}


function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}

cron.schedule(' */30 * * * *', () => {
 //   kill()

});

function kill() {
    ps.kill('1', function (err) {
        if (err) {
            throw new Error(err);
        } else {
            console.log('Process %s has been killed!', 1);
        }
    });
}


ok()

async function ok() {
    await sleep(5000)
    run()
}

function isIpAlive(proxy) {

    return new Promise(function (resolve, reject) {

        checkProcessWork(proxy.ip, proxy.ipdate).then(port => {

            if (!port) {
                let last = {
                    alive: false,
                    lost: 0,
                    scanner: scanner,
                    ipdate: proxy.ipdate,
                    id: proxy.id,
                    retry: proxy.retry,
                    ip: proxy.ip
                }
                if (proxy.justPing)
                    last.justPing = true
                resolve(last)
            }

            let command = 'ping  -c 8 ' + proxy.ip

            let a = shell.exec(command, {async: true});
            a.stdout.on('data', function (data) {
                if (data.includes('transmitted')) {

                    data = data.split(',')[2].split('%')[0]
                    data = parseInt(data)
                    let alive = data < 50


                    console.log('id: ' + proxy.id + " Ip: " + proxy.ip + " PLost: " + data + ' isAlive: ' + alive)
                    proxy.alive = alive
                    proxy.list = data
                    let last = {
                        alive: alive,
                        lost: data,
                        scanner: scanner,
                        ipdate: proxy.ipdate,
                        id: proxy.id,
                        retry: proxy.retry,
                        ip: proxy.ip
                    }
                    if (proxy.justPing)
                        last.justPing = true
                    resolve(last)


                }
            });
        })


    });


}


function testIp(proxy) {
    const request = require('request');
    let port = 3000


    let url = 'http://' + proxy.ip + ':' + port + '/dd/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 10000}, function (error, res, body) {

            let alive = true

            if (error) {
                console.log(error.message)
                alive = false
                if (!error.message.includes('ECONNREFUSED')) {
                    alive = false
                    console.log(error.message)

                }

            }

            if (alive)
                console.log(proxy.ip + '  is  work')
            else
                console.log(proxy.ip + '  is not  work')

            let last = {
                alive: alive,
                lost: 0,
                scanner: scanner,
                ipdate: proxy.ipdate,
                id: proxy.id,
                retry: proxy.retry,
                ip: proxy.ip
            }
            if (proxy.justPing)
                last.justPing = true


            resolve(last)

        });
    });

}

async function checkProcessWork(ip, ipdate) {
    return true
    let d = getMinDiff(ipdate)
    if (d < 1)
        return true
    let a = shell.exec('nc  -vz ' + ip + ' 443', {async: true});
    return new Promise(function (resolve, reject) {


        a.stderr.on('data', function (data) {
            // console.log(data)
            if (data.includes('open'))
                resolve(true)
            resolve(false)
        })
    });

}

async function checkNeedTrueOrFalse(proxy, plost, alive) {
    let res = needSend(proxy.ip, 1, proxy.ipdate)
    if (!res)
        return
    console.log("Send proxy with ip:" + proxy.ip + ' With PLost :', plost, ' And 22 Port Is ', alive)
    let url = 'http://45.82.139.138/send'
    proxy.scanner = scanner
    proxy.lost = plost
    return await postRequest(url, proxy)

    // chat.emit('checkNeedTrueOrFalsePost', proxy);
    // return


}

async function sendAll(proxy) {
    let url = 'http://45.82.139.138/sendAll'
    return await postRequest(url, proxy)
}

function getMinDiff(end) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment().tz('Asia/Tehran').format());
    var end = moment.duration(now.diff(moment(end).tz('Asia/Tehran')));
    return parseInt(end.asMinutes())


}

async function getAllNeedCheckProxy() {
    let url = 'http://45.82.139.138/getAll/' + scanner
    return await doRequest(url)
}


function needSend(ip, num, date) {


    let needAdd = true
    for (let i = 0; i < ips.length; i++) {
        if (ips[i].ip === ip) {
            needAdd = false


            if (num === 1) {


                if (ips[i].count >= trys) {
                    ips[i].count = ips[i].count + 1
                    return true
                } else {
                    ips[i].count = ips[i].count + 1
                    return false
                }
            } else {
                ips[i].count = 0
                return false
            }


        }


    }

    if (needAdd)
        ips.push({ip: ip, count: 0})

    return false
}

function doRequest(url) {

    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            try {
                if (!error) {
                    try {
                        let d = cryptLib.decryptCipherTextWithRandomIV(body, key)
                        resolve(JSON.parse(d));
                    } catch (e) {
                        resolve(true)
                    }

                } else {
                    reject(error);
                }
            } catch (e) {
                console.log(e)
                reject('Error Request');
            }

        });
    });
}


function postRequest(url, data) {
    data = JSON.stringify(data)
    data = cryptLib.encryptPlainTextWithRandomIV(data, key)


    var options = {
        method: 'POST',
        url: url,
        timeout: 15000,
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        body: 'data=' + Buffer.from(data).toString('base64')

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {
            if (error)
                console.log(error)
            resolve(true)

        });
    });
}