/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.TextView;
import net.hockeyapp.android.UpdateActivityInterface;
import net.hockeyapp.android.UpdateInfoListener;
import net.hockeyapp.android.UpdateManager;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.listeners.DownloadFileListener;
import net.hockeyapp.android.objects.ErrorObject;
import net.hockeyapp.android.tasks.DownloadFileTask;
import net.hockeyapp.android.utils.VersionHelper;
import net.hockeyapp.android.views.UpdateView;

public class UpdateActivity
extends Activity
implements UpdateActivityInterface,
UpdateInfoListener,
View.OnClickListener {
    private final int DIALOG_ERROR_ID = 0;
    private ErrorObject error;
    private Context context;
    protected DownloadFileTask downloadTask;
    protected VersionHelper versionHelper;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTitle("App Update");
        this.setContentView((View)this.getLayoutView());
        this.context = this;
        this.versionHelper = new VersionHelper(this.getIntent().getStringExtra("json"), this);
        this.configureView();
        this.downloadTask = (DownloadFileTask)((Object)this.getLastNonConfigurationInstance());
        if (this.downloadTask != null) {
            this.downloadTask.attach((Context)this);
        }
    }

    protected void configureView() {
        TextView nameLabel = (TextView)this.findViewById(4098);
        nameLabel.setText((CharSequence)this.getAppName());
        TextView versionLabel = (TextView)this.findViewById(4099);
        versionLabel.setText((CharSequence)("Version " + this.versionHelper.getVersionString() + "\n" + this.versionHelper.getFileInfoString()));
        Button updateButton = (Button)this.findViewById(4100);
        updateButton.setOnClickListener((View.OnClickListener)this);
        WebView webView = (WebView)this.findViewById(4101);
        webView.clearCache(true);
        webView.destroyDrawingCache();
        webView.loadDataWithBaseURL("https://sdk.hockeyapp.net/", this.getReleaseNotes(), "text/html", "utf-8", null);
    }

    protected String getReleaseNotes() {
        return this.versionHelper.getReleaseNotes(false);
    }

    public Object onRetainNonConfigurationInstance() {
        if (this.downloadTask != null) {
            this.downloadTask.detach();
        }
        return this.downloadTask;
    }

    protected void startDownloadTask() {
        String url = this.getIntent().getStringExtra("url");
        this.startDownloadTask(url);
    }

    protected void startDownloadTask(String url) {
        this.createDownloadTask(url, new DownloadFileListener(){

            public void downloadSuccessful(DownloadFileTask task) {
                UpdateActivity.this.enableUpdateButton();
            }

            public void downloadFailed(DownloadFileTask task, Boolean userWantsRetry) {
                if (userWantsRetry.booleanValue()) {
                    UpdateActivity.this.startDownloadTask();
                } else {
                    UpdateActivity.this.enableUpdateButton();
                }
            }

            public String getStringForResource(int resourceID) {
                UpdateManagerListener listener = UpdateManager.getLastListener();
                if (listener != null) {
                    return listener.getStringForResource(resourceID);
                }
                return null;
            }
        });
        this.downloadTask.execute(new String[0]);
    }

    protected void createDownloadTask(String url, DownloadFileListener listener) {
        this.downloadTask = new DownloadFileTask((Context)this, url, listener);
    }

    public void enableUpdateButton() {
        View updateButton = this.findViewById(4100);
        updateButton.setEnabled(true);
    }

    public int getCurrentVersionCode() {
        int currentVersionCode = -1;
        try {
            currentVersionCode = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)128).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return currentVersionCode;
    }

    public ViewGroup getLayoutView() {
        return new UpdateView((Context)this);
    }

    public String getAppName() {
        try {
            PackageManager pm = this.getPackageManager();
            ApplicationInfo applicationInfo = pm.getApplicationInfo(this.getPackageName(), 0);
            return ((Object)pm.getApplicationLabel(applicationInfo)).toString();
        }
        catch (PackageManager.NameNotFoundException exception) {
            return "";
        }
    }

    private boolean isWriteExternalStorageSet(Context context) {
        String permission = "android.permission.WRITE_EXTERNAL_STORAGE";
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    private boolean isUnknownSourcesChecked() {
        String[] projection = new String[]{"value"};
        String selection = "name = ? AND value = ?";
        Cursor query = null;
        if (Build.VERSION.SDK_INT >= 17) {
            String[] selectionArgs = new String[]{"install_non_market_apps", String.valueOf(1)};
            query = this.getContentResolver().query(Settings.Global.CONTENT_URI, projection, selection, selectionArgs, null);
        } else {
            String[] selectionArgs = new String[]{"install_non_market_apps", String.valueOf(1)};
            query = this.getContentResolver().query(Settings.Secure.CONTENT_URI, projection, selection, selectionArgs, null);
        }
        return query.getCount() == 1;
    }

    public void onClick(View v) {
        if (!this.isWriteExternalStorageSet(this.context)) {
            this.error = new ErrorObject();
            this.error.setMessage("The permission to access the external storage permission is not set. Please contact the developer.");
            this.runOnUiThread(new Runnable(){

                public void run() {
                    UpdateActivity.this.showDialog(0);
                }
            });
            return;
        }
        if (!this.isUnknownSourcesChecked()) {
            this.error = new ErrorObject();
            this.error.setMessage("The installation from unknown sources is not enabled. Please check the device settings.");
            this.runOnUiThread(new Runnable(){

                public void run() {
                    UpdateActivity.this.showDialog(0);
                }
            });
            return;
        }
        this.startDownloadTask();
        v.setEnabled(false);
    }

    protected Dialog onCreateDialog(int id) {
        switch (id) {
            case 0: {
                return new AlertDialog.Builder((Context)this).setMessage((CharSequence)"An error has occured").setCancelable(false).setTitle((CharSequence)"Error").setIcon(17301543).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id) {
                        UpdateActivity.this.error = null;
                        dialog.cancel();
                    }
                }).create();
            }
        }
        return null;
    }

    protected void onPrepareDialog(int id, Dialog dialog) {
        switch (id) {
            case 0: {
                AlertDialog messageDialogError = (AlertDialog)dialog;
                if (this.error != null) {
                    messageDialogError.setMessage((CharSequence)this.error.getMessage());
                    break;
                }
                messageDialogError.setMessage((CharSequence)"An unknown error has occured.");
            }
        }
    }
}

