/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import java.io.File;

public class Constants {
    public static String FILES_PATH = null;
    public static String APP_VERSION = null;
    public static String APP_VERSION_NAME = null;
    public static String APP_PACKAGE = null;
    public static String ANDROID_VERSION = null;
    public static String PHONE_MODEL = null;
    public static String PHONE_MANUFACTURER = null;
    public static final String TAG = "HockeyApp";
    public static final String BASE_URL = "https://sdk.hockeyapp.net/";
    public static final String SDK_NAME = "HockeySDK";
    public static final String SDK_VERSION = "3.0.1";

    public static void loadFromContext(Context context) {
        ANDROID_VERSION = Build.VERSION.RELEASE;
        PHONE_MODEL = Build.MODEL;
        PHONE_MANUFACTURER = Build.MANUFACTURER;
        Constants.loadFilesPath(context);
        Constants.loadPackageData(context);
    }

    private static void loadFilesPath(Context context) {
        if (context != null) {
            try {
                File file = context.getFilesDir();
                if (file != null) {
                    FILES_PATH = file.getAbsolutePath();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception thrown when accessing the files dir:");
                e.printStackTrace();
            }
        }
    }

    private static void loadPackageData(Context context) {
        if (context != null) {
            try {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                APP_PACKAGE = packageInfo.packageName;
                APP_VERSION = "" + packageInfo.versionCode;
                APP_VERSION_NAME = packageInfo.versionName;
                int buildNumber = Constants.loadBuildNumber(context, packageManager);
                if (buildNumber != 0 && buildNumber > packageInfo.versionCode) {
                    APP_VERSION = "" + buildNumber;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception thrown when accessing the package info:");
                e.printStackTrace();
            }
        }
    }

    private static int loadBuildNumber(Context context, PackageManager packageManager) {
        try {
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            Bundle metaData = appInfo.metaData;
            if (metaData != null) {
                return metaData.getInt("buildNumber", 0);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception thrown when accessing the application info:");
            e.printStackTrace();
        }
        return 0;
    }
}

