/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;

public class PrefsUtil {
    private SharedPreferences feedbackTokenPrefs;
    private SharedPreferences.Editor feedbackTokenPrefsEditor;
    private SharedPreferences nameEmailSubjectPrefs;
    private SharedPreferences.Editor nameEmailSubjectPrefsEditor;

    private PrefsUtil() {
    }

    public static PrefsUtil getInstance() {
        return PrefsUtilHolder.INSTANCE;
    }

    public void saveFeedbackTokenToPrefs(Context context, String token) {
        if (context != null) {
            this.feedbackTokenPrefs = context.getSharedPreferences("net.hockeyapp.android.prefs_feedback_token", 0);
            if (this.feedbackTokenPrefs != null) {
                this.feedbackTokenPrefsEditor = this.feedbackTokenPrefs.edit();
                this.feedbackTokenPrefsEditor.putString("net.hockeyapp.android.prefs_key_feedback_token", token);
                PrefsUtil.applyChanges(this.feedbackTokenPrefsEditor);
            }
        }
    }

    public String getFeedbackTokenFromPrefs(Context context) {
        if (context == null) {
            return null;
        }
        this.feedbackTokenPrefs = context.getSharedPreferences("net.hockeyapp.android.prefs_feedback_token", 0);
        if (this.feedbackTokenPrefs == null) {
            return null;
        }
        return this.feedbackTokenPrefs.getString("net.hockeyapp.android.prefs_key_feedback_token", null);
    }

    public void saveNameEmailSubjectToPrefs(Context context, String name, String email, String subject) {
        if (context != null) {
            this.nameEmailSubjectPrefs = context.getSharedPreferences("net.hockeyapp.android.prefs_name_email", 0);
            if (this.nameEmailSubjectPrefs != null) {
                this.nameEmailSubjectPrefsEditor = this.nameEmailSubjectPrefs.edit();
                if (name == null || email == null || subject == null) {
                    this.nameEmailSubjectPrefsEditor.putString("net.hockeyapp.android.prefs_key_name_email", null);
                } else {
                    this.nameEmailSubjectPrefsEditor.putString("net.hockeyapp.android.prefs_key_name_email", String.format("%s|%s|%s", name, email, subject));
                }
                PrefsUtil.applyChanges(this.nameEmailSubjectPrefsEditor);
            }
        }
    }

    public String getNameEmailFromPrefs(Context context) {
        if (context == null) {
            return null;
        }
        this.nameEmailSubjectPrefs = context.getSharedPreferences("net.hockeyapp.android.prefs_name_email", 0);
        if (this.nameEmailSubjectPrefs == null) {
            return null;
        }
        return this.nameEmailSubjectPrefs.getString("net.hockeyapp.android.prefs_key_name_email", null);
    }

    public static void applyChanges(SharedPreferences.Editor editor) {
        if (PrefsUtil.applySupported().booleanValue()) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    public static Boolean applySupported() {
        try {
            return Build.VERSION.SDK_INT >= 9;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static class PrefsUtilHolder {
        public static final PrefsUtil INSTANCE = new PrefsUtil();

        private PrefsUtilHolder() {
        }
    }
}

