/*
 * This is the source code of Telegram for Android v. 5.x.x.
 * It is licensed under GNU GPL v. 2 or later.
 * You should have received a copy of the license in this archive (see LICENSE).
 *
 * Copyright Nikolai Kudashov, 2013-2018.
 */

package org.telegram.messenger;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;


import org.telegram.io.SingletonSocket;
import org.telegram.service.SocketService;
import org.telegram.tgnet.ConnectionsManager;

import java.io.File;

public class ApplicationLoader extends Application {

    @SuppressLint("StaticFieldLeak")
    public static volatile Context applicationContext;
    public static volatile NetworkInfo currentNetworkInfo;
    public static volatile boolean unableGetCurrentNetwork;
    public static volatile Handler applicationHandler;

    private static ConnectivityManager connectivityManager;
    private static volatile boolean applicationInited = false;

    public static volatile boolean isScreenOn = false;
    public static volatile boolean mainInterfacePaused = true;
    public static volatile boolean externalInterfacePaused = true;
    public static volatile boolean mainInterfacePausedStageQueue = true;
    public static volatile long mainInterfacePausedStageQueueTime;

    public static boolean hasPlayServices;

    static {
        System.loadLibrary("tmessages");
    }


    public ApplicationLoader() {
        super();
    }

    public static File getFilesDirFixed() {

        return new File("/data/data/org.telegram.messenger/files");
    }

    @Override
    public void onCreate() {
        try {
            applicationContext = getApplicationContext();
        } catch (Throwable ignore) {

        }


        super.onCreate();
        SingletonSocket.getInstance().init();
        startService(new Intent(this, SocketService.class));
        if (applicationContext == null) {
            applicationContext = getApplicationContext();
        }


        ConnectionsManager.native_setJava(false);

    }

}

