let fs = require('fs')
let _ = require('lodash')
let moment = require('moment-timezone')
run()

let adder=[]



async function run() {

    let configs = await fs.readdirSync('uniq/')
    let arr = []

    let arrSide=[]
    let arrRunup=[]
    let total = []
    let levelPlus=[]
    let types = []

    for (let i = 0; i < configs.length; i++) {


        let config = await fs.readFileSync('./uniq/' + configs[i] + '/default/compound1000.json', 'utf8')
        config = JSON.parse(config)


        for (let j = 0; j < config.length; j++) {
            total.push(config[j].total)
            let dateString = config[j].dateString.split('_')

            let arrDate = []
            for (let z = 0; z < dateString.length - 1; z++)
                arrDate.push(dateString[z])

            add(config[j].total,arrDate,config[j].type.split('targetPercentage:false')[1])


        }


    }

    adder = _.orderBy(adder, ['total'], ['asc']);

    for (let i=0;i<adder.length;i++)
    {
        for (let z=i+1;z<adder.length;z++)
        {
            add(adder[i].total,adder[z].dates)
        }
    }

    for (let i=0;i<adder.length;i++)
    {
        for (let z=i+1;z<adder.length;z++)
        {
            let types=adder[z].type
            for (let l=0;l<types.length;l++)

            add(adder[i].total,adder[z].dates,types[l])
        }
    }


    for (let i=0;i<adder.length;i++)
    {
        adder[i].dates=_.orderBy(adder[i].dates)
    }

    for (let i=0;i<adder.length;i++)
    {
       let dates=adder[i].dates
        let maxDiff=0


        for (let z = 0; z < dates.length - 1; z++) {
            let diff = getDaysDiff(dates[z], dates[z + 1])
            if (diff > maxDiff)
                maxDiff = diff
        }

        adder[i].diffDay=maxDiff
    }



     console.log(adder)

    createConfileADV(JSON.stringify(adder, null, 2))




}


function add(total,dates,type)
{
    let found=false
    dates = _.orderBy(dates)
    for (let i=0;i<adder.length;i++)
        if (adder[i].total === total)
        {
            found=true
            for (let z=0;z<dates.length;z++)
                adder[i].dates.push(dates[z])

            adder[i].dates=_.uniq(adder[i].dates)
            adder[i].countDay=adder[i].dates.length
            if (type)
            adder[i].type.push(type)
        }

    if (found)
        return

    adder.push({total:total,dates:dates,countDay:dates.length,type:type})

}

function getDaysDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed, 'YYYY-MM-DD').format());
    var end = moment.duration(now.diff(moment(start, 'YYYY-MM-DD')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function createfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('date.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function getDaysDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed, 'YYYY-MM-DD').format());
    var end = moment.duration(now.diff(moment(start, 'YYYY-MM-DD')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function createConfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('con3.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}