const fs = require('fs');
const csv = require('fast-csv');
let _ = require('lodash')
let moment = require('moment-timezone')

let ai = require('./ai')


async function parse(directory, name, configs, risk, pfTrade, side, riskFreeLevel,detail,onlyShortLong,loss,dur,maxTradeDays,targetPercentage,candles,fft,ProfitZeroProfit,fftRunup,ProfitZeroProfitRunup,ProfitZeroDrawDownProfit,usage) {

    return new Promise(function (resolve, reject) {
        let arr = []
        // console.log(name)
        fs.createReadStream('work/'+directory + '/' + name)
            .pipe(csv.parse({headers: true}))
            .on('error', error => reject(error))
            .on('data', row => arr.push(row))
            .on('end', rowCount => resolve(initData(arr, configs, name, risk, pfTrade, side, riskFreeLevel,detail,onlyShortLong,loss,dur,maxTradeDays,targetPercentage,candles,fft,ProfitZeroProfit,fftRunup,ProfitZeroProfitRunup,ProfitZeroDrawDownProfit,usage)));
    });
}


function initData(data, config, name, risk, pfTrade, side, riskFreeLevel,detail,onlyShortLong,loss,dur,maxTradeDays,targetPercentage,candles,fft,ProfitZeroProfit,fftRunup,ProfitZeroProfitRunup,ProfitZeroDrawDownProfit,usage) {

    data = JSON.stringify(data)


    data = _.replace(data, new RegExp('Trade #', 'g'), 'id')
    data = _.replace(data, new RegExp('Profit %', 'g'), 'profit')
    data = _.replace(data, new RegExp('Run-up %', 'g'), 'runUp')
    data = _.replace(data, new RegExp('Drawdown %', 'g'), 'drawDown')
    data = _.replace(data, new RegExp('Price', 'g'), 'price')
    data = _.replace(data, new RegExp('Date/Time', 'g'), 'date')
    // data = _.replace(data, new RegExp('Open_Price', 'g'), 'openPrice')
    // data = _.replace(data, new RegExp('Num.', 'g'), 'id')

    let t = data
    //  console.log(data)
    data = JSON.parse(data)

    let arr = []
    if (t.includes('Open_Time')) {
        data = _.sortBy(data, function (o) {
            return new moment(o.Open_Time, 'YYYY.MM.DD HH:mm:ss').format('YYYY-MM-DD HH:mm:ss')
        });
        if (onlyShortLong ===true)
        {
            let arr2=[]
            let lastSide=''
            for (let i=0;i<data.length;i++)
            {
                if (lastSide ==='') {
                    arr2.push(data[i])
                    lastSide = data[i].Type
                    continue
                }

                if (lastSide === data[i].Type)
                    continue
                arr2.push(data[i])
                lastSide=data[i].Type
            }

            data=arr2

        }
        for (let i = 0; i < data.length; i++) {
            if (data.length - 1 === i)
                continue
            //     console.log(data[i])
            if (data[i].dAgeHiPrfInPrPc_RunUpPc === '')
                continue
            let obj = {}
            obj.id = (i + 1)
            obj.signal = name
            if (data[i].Type.includes('Buy'))
                obj.side = 'LONG'
            else
                obj.side = 'SHORT'

            if (side === 'long' && obj.side === 'SHORT')
                continue
            if (side === 'short' && obj.side === 'LONG')
                continue
            obj.openPrice = parseFloat(data[i].Open_price)
            obj.closePrice = parseFloat(data[i].Close_price)
            obj.openDate = moment(data[i].Open_Time, 'YYYY.MM.DD HH:mm:ss').format('YYYY-MM-DD HH:mm:ss')
           // obj.unixOpen = parseFloat(data[i].openunix)
          //  obj.unixClose = parseFloat(data[i].closeunix)


            obj.closeDate = moment(data[i].Close_Time, 'YYYY.MM.DD HH:mm:ss').format('YYYY-MM-DD HH:mm:ss')

            obj.profit = parseFloat(data[i].dPrfPipWrtOpPrPc)
            obj.runUp = parseFloat(data[i].dAgeHiPrfInPrPc_RunUpPc)
            obj.drawDown = parseFloat(data[i].dAgeLoPrfInPrPc_DrawDownPc)

            //  obj.drawDown = obj.dAgeLoPrfInPrPc_DrawDownPc * -1


            arr.push(obj)
            //  let arr=

        }
    } else {

        for (let i = 0; i < data.length; i = i + 2) {
            if (data[i].runUp === '')
                continue
            let obj = {}
            obj.id = parseInt(data[i].id)
            obj.signal =name
            if (data[i].Type.includes('Long'))
                obj.side = 'LONG'
            else
                obj.side = 'SHORT'
            obj.openPrice = parseFloat(data[i].price)
            obj.closePrice = parseFloat(data[i + 1].price)
            obj.openDate = data[i].date
            obj.closeDate = data[i + 1].date
            obj.profit = parseFloat(data[i].profit)
            obj.runUp = parseFloat(data[i].runUp)
            obj.drawDown = parseFloat(data[i].drawDown)

            obj.drawDown = obj.drawDown * -1


            arr.push(obj)
            //  let arr=

        }
    }





    // console.log(arr)


    let cz = []
    for (let i = 0; i < config.length; i++) {
        let d = ai.run(arr, config[i], config[i].risk, config[i].pfTrade, config[i].riskFreeLevel,detail,config[i].loss,config[i].dur,config[i].maxTradeDays,config[i].targetPercentage,candles,config[i].fft,config[i].ProfitZeroProfit,config[i].fftRunup,config[i].ProfitZeroProfitRunup,config[i].ProfitZeroDrawDownProfit,config[i].ProfitZeroDrawDown,config[i].ddPlusRunCount,config[i].RunupDrawDownZeroRunupDrawDown,config[i].ProfitZeroRunupProfit,config[i].ProfitZeroRunupDrawDown,config[i].RunUpDrawDownZeroProfit,config[i].RunUpDrawDownZeroDrawDownProfit,config[i].RunUpDrawDownZeroDrawdown,config[i].RunUpDrawDownZeroRunupProfit,config[i].RunupZeroRunupDrawDown,config[i].RunupZeroProfit,config[i].RunupZeroProfitDrawDown,config[i].RunupZeroDrawDown,config[i].RunupZeroProfitRunup,config[i].DrawDownZeroDrawDown,config[i].DrawDownnZeroProfit,config[i].DrawDownZeroProfitDrawDown,config[i].DrawDownZeroProfitRunup,config[i].DrawDownZeroRunupDrawDown,config[i].ProfitDrawDownZeroDrawDown,config[i].ProfitDrawDownZeroProfit,config[i].ProfitDrawDownZeroProfitDrawDown,config[i].ProfitDrawDownZeroProfitRunup,config[i].ProfitDrawDownZeroRunupDrawDown
           ,config[i].ProfitRunupZeroDrawDown,config[i].ProfitRunupZeroProfit,config[i].ProfitRunupZeroProfitDrawDown,config[i].ProfitRunupZeroProfitRunup,config[i].ProfitRunupZeroRunupDrawDown ,config[i].usage)
        if (d !== null)
            cz.push(d)
    }
    return cz


}


module.exports =
    {

        parse: parse,


    }
