const fs = require('fs')
let moment = require('moment-timezone')
let _ = require('lodash')
const uuid=require('uniqid')
let pairs=''
let res
init()


async function init() {


    res = await fs.readFileSync('run.csv', 'utf8');
    res = res.split('\n')
    let arr = []
    //  console.log(found('ETH', 'Lp2'))

    let com = await fs.readFileSync('com.json', 'utf8');
    com = JSON.parse(com)
    for (let i=0;i<com.length;i++)
    {
        let t = com[i].platform
        t = t.split('_')
        let lp = t[4]
        com[i].lp=lp
        com[i].uniq=uuid.time()+'_'+com[i].type.split(' ')[6]+'_'+(parseFloat(com[i].type.split(' ')[7])*-1)

    }
    com=_.uniqBy(com, 'lp');
    let newCom=[]
    for (let i=0;i<100;i++)
    {
        newCom.push(com[i])
    }
    com=newCom
    createComResfileADV(JSON.stringify(com, null, 2))


    for (let i = 0; i < com.length; i++) {
        let t = com[i].platform
        t = t.split('_')


        let pair = t[3].replace('USDT', '').replace('USD', '')
        pairs=pair
        let p=t[t.length-1].split('.')
        p=p[0].split(pairs)[0]
        let lp = t[4]
        let f=found(pair, lp)
        f.period=p
        arr.push(f)
    }
    arr=_.uniqBy(arr, 'name');

    let header='RowNum,PPST1_stMnBarAge,PPST1_PvtPtPeriod,PPST1_AtrFactor,PPST1_AtrPeriod\n'
    for (let i=0;i<100;i++)
    {
        let inline=(i+1)+','+arr[i].timeframe+','+arr[i].pvt+','+arr[i].factor+','+arr[i].period
        header=header+inline
        if (i !== arr.length-1)
            header= header+'\n'

    }

    createRunResfileADV(header)


}

function createRunResfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile(pairs+'_TOP.csv', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createComResfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile(pairs+'newCom.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function found(pair, lp) {
    for (let i = 0; i < res.length; i++) {
        if (!res[i].includes(lp + '_'))
            continue


        let d = res[i].split(',')
        let timeframe = d[13]
        timeframe=timeframe.split(' ')
        let newTimeframe='0d '
        for (let z=1;z<timeframe.length;z++)
        {
            newTimeframe=newTimeframe+timeframe[z]
            if (z !== timeframe.length-1)
                newTimeframe=newTimeframe+' '
        }
        timeframe=newTimeframe
        let pvt = parseFloat(d[14])
        let factor = parseFloat(d[15])
        let period = d[103]
        period = period.split(pair)
        period = parseFloat(period[period.length - 1])
        let name = d[103]

        return {name, timeframe, pvt, factor, period}

    }
}


