let fs = require('fs')
var watch = require('node-watch');
let ai = require('./ai-new')
let path = 'C:\\yMTa\\Set\\AltSet2\\'
let longSide = 'LONG'
let shortSide = 'SHORT'
let bybit = require('./test_bybit')
let zignaly = require('./zignaly')
let redis = require('redis')
const client = redis.createClient(
    {url: 'redis://default:p@db.zignaly.xyz:7001'}
);
let datas = []


const ccxt = require('ccxt')


const exchange = new ccxt.bybit({
    apiKey: "7iW1muhWWyX8PxuQWx",
    secret: "5Bf4FFISdQNxVJqg5pqyn860CIrgjsXXy3pK",
    enableRateLimit: true,

})

exchange.urls['api'] = exchange.urls['test'];


init()


async function init() {
    client.on('error', (err) => console.log('Redis Client Error', err));

    await client.connect();

    run()
}


async function run() {
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {
        if (!files[i].includes('id'))
            continue


        let lastFile = await fs.readFileSync(path + files[i], 'utf8')
        let stats = await fs.statSync(path + files[i])
        lastFile = lastFile.split('\n')
        // console.log(lastFile[lastFile.length - 2])

        let data = grabData(lastFile)


        let vars = ai.run(data)
        let sp = files[i].split('_')
        let id = sp[4]
        let usage = sp[5]
        let value = parseFloat(sp[6])
//console.log(vars.VarProfitDrawDownZeroProfit)
        datas.push({name: files[i], size: stats.size, vars: vars, id: id, usage: usage, value: (-1 * value)})
    }

    // console.log(datas)
    checker()

}


function grabData(data) {
    // console.log(data)
    let arr = []
    for (let i = 0; i < data.length; i++) {


        try {
            let d = data[i].split(',')
            let profit = parseFloat(d[7])
            let runUp = parseFloat(d[8])
            let drawDown = parseFloat(d[9])
            let t=d[6]
            t=t.split(':')
            let closeTime = t[0]+':'+t[1]

            if (isNaN(profit))
                continue
            arr.push({profit, runUp, drawDown, closeTime})
        } catch (e) {

        }

    }

    return arr
}




async function checker() {
    let arr = []
    //  console.log('check')
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {

        if (!files[i].includes('id'))
            continue


        arr.push(make(files[i]))
    }
    await Promise.all(arr)
    await sleep(50)
    return checker()
}

async function make(name) {
    let stats = await fs.statSync(path + name)
    let size = getSizeFromName(name)

    if (size !== stats.size) {
        // console.log(name + ' changes')
        updateSizeFromName(name, stats.size)
        await updateVars(name)
    }


}


async function updateVars(name) {
    let lastFile = await fs.readFileSync(path + name, 'utf8')
    lastFile = lastFile.split('\n')
    let lastData = lastFile[lastFile.length - 2]

    let qty = 0.01
    let sig = ''
    let allData = getAllFromName(name)
    if (lastData.includes('Buy'))
        sig = allData.id + '_Buy'
    else
        sig = allData.id + '_Sell'



    let data = grabData([lastData])
    closer(sig,data[0].closeTime)

    let vars = ai.run(data, getVarsFromName(name))

    let varUsage = getVarFromUsage(vars, allData.usage)
    console.log(allData.id, allData.usage, allData.value, varUsage)
    if (varUsage < allData.value) {
        //  console.log(allData.id +' '+'Try Add usage:'+allData.usage +' with current var '+varUsage +' and less than '+allData.value)
        if (lastData.includes('Buy'))
            sig = allData.id + '_Sell'
        else
            sig = allData.id + '_Buy'
        adder(sig, 0.01, data[0].closeTime)
    }
    // console.log(name,vars)
    updateVarsFromName(name, vars)

}

function getVarFromUsage(vars, usage) {


    if (usage === 'fft') {
        return vars.countDrop
    } else if (usage === 'ddPlusRunCount') {
        return vars.drawDownPlusRunUpCount
    } else if (usage === 'ProfitZeroProfit') {
        return vars.allLossProfit
    } else if (usage === 'RunupDrawDownZeroRunupDrawDown') {
        return vars.drawDownPlusRunUpPercent
    } else if (usage === 'ProfitZeroDrawDown') {
        return vars.ProfitZeroDrawDownPercent
    } else if (usage === 'fftRunup') {
        return vars.countDropRunup
    } else if (usage === 'ProfitZeroDrawDownProfit') {
        return vars.diffDrawdownProfitAll
    } else if (usage === 'ProfitZeroProfitRunup') {
        return vars.canCreateRunupPercent
    } else if (usage === 'ProfitZeroRunupProfit') {
        return vars.VarProfitZeroRunupProfit
    } else if (usage === 'ProfitZeroRunupDrawDown') {
        return vars.VarProfitZeroRunupDrawDown
    } else if (usage === 'RunUpDrawDownZeroProfit') {
        return vars.RunUpDrawDownAllLossProfit
    } else if (usage === 'RunUpDrawDownZeroDrawDownProfit') {
        return vars.RunupDrawDownDiffDrawdownProfitAll
    } else if (usage === 'RunUpDrawDownZeroDrawdown') {
        return vars.runUpDrawDownZeroDrawDownPercent
    } else if (usage === 'RunUpDrawDownZeroRunupProfit') {
        return vars.VarDrawDownZeroProfit
    } else if (usage === 'RunupZeroRunupDrawDown') {
        return vars.VarRunupZeroRunupDrawDown
    } else if (usage === 'RunupZeroProfit') {
        return vars.VarRunupZeroProfit
    } else if (usage === 'RunupZeroProfitDrawDown') {
        return vars.VarRunupZeroProfitDrawDown
    } else if (usage === 'RunupZeroDrawDown') {
        return vars.VarRunupZeroDrawDown
    } else if (usage === 'RunupZeroProfitRunup') {
        return vars.VarRunupZeroProfitRunup
    } else if (usage === 'DrawDownZeroDrawDown') {
        return vars.VarDrawDownZeroDrawDown
    } else if (usage === 'DrawDownnZeroProfit') {
        return vars.VarDrawDownnZeroProfit
    } else if (usage === 'DrawDownZeroProfitDrawDown') {
        return vars.VarDrawDownZeroProfitDrawDown
    } else if (usage === 'DrawDownZeroProfitRunup') {
        return vars.VarDrawDownZeroProfitRunup
    } else if (usage === 'DrawDownZeroRunupDrawDown') {
        return vars.VarDrawDownZeroRunupDrawDown
    } else if (usage === 'ProfitDrawDownZeroDrawDown') {
        return vars.VarProfitDrawDownZeroDrawDown
    } else if (usage === 'ProfitDrawDownZeroProfit') {
        return vars.VarProfitDrawDownZeroProfit
    } else if (usage === 'ProfitDrawDownZeroProfitDrawDown') {
        return vars.VarProfitDrawDownZeroProfitDrawDown
    } else if (usage === 'ProfitDrawDownZeroProfitRunup') {
        return vars.VarProfitDrawDownZeroProfitRunup
    } else if (usage === 'ProfitDrawDownZeroRunupDrawDown') {
        return vars.VarProfitDrawDownZeroRunupDrawDown
    } else if (usage === 'ProfitRunupZeroDrawDown') {
        return vars.VarProfitRunupZeroDrawDown
    } else if (usage === 'ProfitRunupZeroProfit') {
        return vars.VarProfitRunupZeroProfit
    } else if (usage === 'ProfitRunupZeroProfitDrawDown') {
        return vars.VarProfitRunupZeroProfitDrawDown
    } else if (usage === 'ProfitRunupZeroProfitRunup') {
        return vars.VarProfitRunupZeroProfitRunup
    } else if (usage === 'ProfitRunupZeroRunupDrawDown') {
        return vars.VarProfitRunupZeroRunupDrawDown
    }


}


async function closer(sig,date) {
    let lastToken = sig + '__' + date
    const [data, delStatus] = await client
        .multi()
        .get(sig)
        .del(sig)

        .exec();


    if (delStatus !== 1) {

        return
    }


    let qty = JSON.parse(data)
    qty = qty.qty
    console.log('try reduce',sig,qty)
    if (sig.includes('Buy')) {
        exchange.createMarketOrder('ETHUSDT', 'Sell', qty, 0, {reduceOnly: true,order_link_id: lastToken})
    } else {
        exchange.createMarketOrder('ETHUSDT', 'Buy', qty, 0, {reduceOnly: true,order_link_id: lastToken})
    }


}


async function adder(sig, qty, date) {
    let lastToken = sig + '_' + date
    console.log('Add db and ex :',lastToken)
    if (sig.includes('Buy')) {

        let d = await exchange.createMarketOrder('ETHUSDT', 'Buy', qty, 0, {order_link_id: lastToken})
      //  console.log('Add Suc With id',sig)
        if (typeof d.id !=="undefined") {
            console.log('Suc Exchange id',d.id,sig)
            const [add] = await client
                .multi()
                .set(sig, JSON.stringify({qty: qty}))
                .exec();
        }
    } else {
        let d = await exchange.createMarketOrder('ETHUSDT', 'Sell', qty, 0, {order_link_id: lastToken})
      //  console.log('Add Suc With id',sig)
        if (typeof d.id !=="undefined") {
            console.log('Add Suc With id',d.id,sig)
            const [add] = await client
                .multi()
                .set(sig, JSON.stringify({qty: qty}))
                .exec();
        }
    }


}


function getVarsFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].vars
}

function getSizeFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].size
}

function getAllFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i]
}


function updateVarsFromName(name, vars) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            datas[i].vars = vars
}

function updateSizeFromName(name, size) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            datas[i].size = size
}

async function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}


