var AWS = require('aws-sdk');
var shell = require('shelljs');
const request = require('request');
let moment = require('moment-timezone')
let utils = require('./utils')
const fs = require('fs');
const db = require('./../database/db')
var lightsail


class Amazon {
    constructor(account, regionParam, serverParam) {
        this.region = regionParam
        this.server = serverParam


    }

    async init() {
        let ip = await utils.getIp()
        let acc = await db.getAccByIp(ip)
        var config = new AWS.Config({
            accessKeyId: acc.access, secretAccessKey: acc.secret, region: this.region
        });


        lightsail = new AWS.Lightsail(config)
    }


    async getIp(proxy) {
        try {

            await this.deAttachStaticIp()
        } catch (e) {

        }

        await this.attachStaticIp(proxy.instance)
        await this.deAttachStaticIp()
        let ip = await this.getIpAddressOfInstance(proxy.instance)
        try {
            await this.doRequest(ip)
        } catch (e) {
            await this.initFirewall(proxy.instance)
            await this.doRequest(ip)
        }

        return ip

    }


    async createInstance(snap, nparam) {
        let name
        if (nparam)
            name = nparam
        else
            name = 'Cluster' + this.randomInt(0, 500000)
        await this.createInstanceFromSnashot(name, snap)
        await this.sleep(15000)
        // try {
        //     await this.initFirewall(name)
        // }
        // catch (e) {
        //
        // }
        let ip
        try {
            ip = await this.getIpAddressOfInstance(name)
        } catch (e) {

        }

        // await this.doRequest(ip)
        //await rebootInstance(name)
        return {name: name, ip: ip}
    }

    sleep(millis) {
        return new Promise(resolve => setTimeout(resolve, millis));
    }


    attachStaticIp(instance) {

        let ipname = 'StaticIp-1'
        return new Promise(function (resolve, reject) {


            lightsail.attachStaticIp({staticIpName: ipname, instanceName: instance}
                , function (error, data) {
                    if (error) {
                        console.log(error)
                        reject('Error attachStaticIp')
                    }

                    if (data)
                        resolve(true)
                });

        });
    }

    deAttachStaticIp() {

        let ipname = 'StaticIp-1'
        return new Promise(function (resolve, reject) {


            lightsail.detachStaticIp({staticIpName: ipname}, function (error, data) {
                if (error) {
                    reject('Error deAttachStaticIp')
                }

                if (data)
                    resolve(true)
            })

        });
    }


    releaseStaticIp(name) {


        return new Promise(function (resolve, reject) {
            var params = {
                staticIpName: name /* required */
            };

            lightsail.releaseStaticIp(params
                , function (error, data) {
                    if (error)
                        reject('Error releaseStaticIp')
                    if (data)
                        resolve(true)
                });

        });
    }


    createSnapshutFromInstace() {
        return new Promise(function (resolve, reject) {

            var params = {
                instanceName: 'Ubuntu-1', /* required */
                instanceSnapshotName: 'snapx', /* required */


            };
            lightsail.createInstanceSnapshot(params, function (err, data) {
                if (err)
                    reject('Error create snapx')
                if (data)
                    resolve(true)
            });


        });
    }


    createStaticIp(name) {


        return new Promise(function (resolve, reject) {

            var params = {
                staticIpName: name /* required */
            };
            lightsail.allocateStaticIp(params
                , function (error, data) {
                    if (error) {
                        console.log(error)
                        reject('Error createStaticIp')
                    }

                    if (data)
                        resolve(data)
                });

        });
    }


    getAllInstances() {


        return new Promise(function (resolve, reject) {


            lightsail.getInstances(function (error, data) {
                if (error) {
                    console.log(error)
                    reject('Error getAllInstances')
                }

                if (data)
                    resolve(data.instances)

            })

        });
    }


    getAllIps() {


        return new Promise(function (resolve, reject) {


            lightsail.getStaticIps(function (error, data) {
                if (error)
                    reject('Error getAllIps')
                if (data)
                    resolve(data.staticIps)

            })

        });
    }

    rebootInstance(proxy) {


        return new Promise(function (resolve, reject) {


            lightsail.rebootInstance({instanceName: proxy.instance}, function (error, data) {
                if (error) {
                    console.log(error)
                    resolve(false)
                }

                if (data)
                    resolve(true)
            })

        });
    }

    getIpAddressOfInstance(instance) {
        return new Promise(function (resolve, reject) {
            lightsail.getInstance({instanceName: instance}, function (error, data) {
                if (error) {
                    console.log(error)
                    reject('Error getIpAddressOfInstance')
                }

                if (data)
                    resolve(data.instance.publicIpAddress)
            });
        });
    }

    deleteInstance(instance) {
        var params = {
            instanceName: instance /* required */
        };
        return new Promise(function (resolve, reject) {
            lightsail.deleteInstance(params, function (error, data) {
                if (error)
                    reject('Error deleteInstance')
                if (data)
                    resolve(data)

            });
        });
    }

    getInstance(instance) {

        return new Promise(function (resolve, reject) {
            lightsail.getInstance({instanceName: instance}, function (error, data) {
                if (error)
                    reject('Error getInstance')
                if (data)
                    resolve(data.instance)
            });
        });
    }

    initFirewall(instance) {
        return new Promise(function (resolve, reject) {
            var params = {
                instanceName: instance,
                portInfos: [
                    {
                        fromPort: 0,
                        protocol: 'all',
                        toPort: 65535
                    },
                ]
            };
            lightsail.putInstancePublicPorts(params, function (error, data) {
                if (error) {
                    console.log(error)
                    reject('Error putInstancePublicPorts')
                }

                if (data)
                    resolve(data)
            });
        });
    }


    copySnapShut(snap, region) {
        return new Promise(function (resolve, reject) {
            var params = {
                sourceRegion: region,
                targetSnapshotName: snap,
                sourceSnapshotName: snap,

            };
            lightsail.copySnapshot(params, function (error, data) {
                if (error) {
                    console.log(error)
                    reject('Error copySnapshot')
                }

                if (data)
                    resolve(data)
            });
        });
    }

    getInstanceOpenPort(instance) {
        return new Promise(function (resolve, reject) {
            lightsail.getInstancePortStates({instanceName: instance}, function (error, data) {
                if (error)
                    reject(error)
                if (data)
                    resolve(data)
            });
        });
    }

    createInstanceFromSnashot(instanceName, snap) {
        let reg = this.region
        let server = this.server
        return new Promise(function (resolve, reject) {

            var params = {
                availabilityZone: reg + 'a', /* required */
                bundleId: server, /* required */
                instanceNames: [instanceName],
                instanceSnapshotName: snap, /* required */
            };
            lightsail.createInstancesFromSnapshot(params, function (error, data) {
                if (error) {
                    console.log(error)
                    reject('Error createInstancesFromSnapshot')

                }

                if (data)
                    resolve(data)
            });
        });
    }

    createInstanceFromNormalWay() {
        let reg = this.region
        let server = 'large_2_0'
        let command = " cd /home/ubuntu &&  " +
            " git clone http://49.12.200.60/root/mt2oldAmazon.git" +
            " && mv mt2oldAmazon mt" +
            " && cd mt && chmod 777 " +
            "* && ./install.sh && cd .." +
            " && git clone http://49.12.200.60/root/rt2old.git " +
            "&& mv rt2old rt2 &&  " +
            "cd rt2 && chmod" +
            " 777 * && ./run.sh &&  " +
            "sudo pm2 start app.js &&  " +
            "sudo  pm2 startup &&  "
            + "sudo  pm2 save && " +
            "sleep 5 && reboot"
        return new Promise(function (resolve, reject) {

            var params = {
                availabilityZone: reg + 'a', /* required */
                blueprintId: 'ubuntu_18_04', /* required */
                bundleId: 'large_2_0', /* required */
                instanceNames: [ /* required */
                    'Ubuntu-1',
                    'Ubuntu-2'

                ],
                userData: command
            };

            if (reg === 'eu-north-1')
                params.bundleId = 'large_2_3'

            lightsail.createInstances(params, function (error, data) {
                if (error) {
                    console.log(error)
                    reject('Error createInstancesFromNormalWay')

                }

                if (data) {
                    console.log(data)
                    resolve(data)
                }

            });
        });
    }

    async foundInstance(meta) {
        let instance = await this.getAllInstances()
        for (let i = 0; i < instance.length; i++) {
            if (instance[i].name === meta) {
                return {found: true, createdAt: instance[i].createdAt}
            }

        }

        return {found: false}


    }

    async foundNormalInstance(meta) {
        let instance = await this.getAllInstances()
        for (let i = 0; i < instance.length; i++) {
            if (instance[i].name === meta) {
                return true
            }

        }

        return false


    }


    async getDaysCreate(meta) {
        let instance = await this.getAllInstances()
        for (let i = 0; i < instance.length; i++) {
            if (instance[i].name === meta)
                return this.getMinDays(instance[i].createdAt)
        }

        return false


    }

    getMinDays(end) {

        var now = moment(moment().tz('Asia/Tehran').format());
        var end = moment.duration(now.diff(moment(end).tz('Asia/Tehran')));
        return parseInt(end.asDays())


    }

    async isIpAlive(ip) {
        let a = await shell.exec('ping  ' + ip + ' -c 3', {silent: true}).stdout;
        a = a.split(',')[2].split('%')[0]
        a = parseInt(a)

        return a <= 30


    }


    randomInt(low, high) {
        return Math.floor(Math.random() * (high - low) + low)
    }


    doRequest(ip) {
        let url = 'http://' + ip + ':3000'
        return new Promise(function (resolve, reject) {
            request(url, {timeout: 6000}, function (error, res, body) {
                try {
                    if (!error && res.statusCode === 200) {
                        resolve(body);
                    } else {
                        reject(error);
                    }
                } catch (e) {
                    reject('Error Request');
                }

            });
        });
    }


}


module.exports = Amazon;