let fs = require('fs')
var watch = require('node-watch');
let ai = require('./ai-new')
let path = 'C:\\yMTa - 2\\Set\\AiTest\\Newfolder2\\'
let longSide = 'LONG'
let shortSide = 'SHORT'
let zignaly = require('./zignaly')

let longToken = 'a7d9ab4de89d2717f54182e008f62cd2'
let shortToken = '268267180105f463a69d8933a498fadc'
let longId = 'ETHLONG'
let shortId = 'ETHSHORT'
let datas = []


run()

async function run() {
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {
        if (!files[i].includes('Lp2'))
            continue


        let lastFile = await fs.readFileSync(path + files[i], 'utf8')
        let stats = await fs.statSync(path + files[i])
        lastFile = lastFile.split('\n')
        // console.log(lastFile[lastFile.length - 2])

        let data = grabData(lastFile)


        let vars = ai.run(data)

        datas.push({name: files[i], size: stats.size, vars: vars})
    }

    // console.log(datas)
    checker()

}


function grabData(data) {
    // console.log(data)
    let arr = []
    for (let i = 0; i < data.length; i++) {


        try {
            let d = data[i].split(',')
            let profit = parseFloat(d[7])
            let runUp = parseFloat(d[8])
            let drawDown = parseFloat(d[9])

            if (isNaN(profit))
                continue
            arr.push({profit, runUp, drawDown})
        } catch (e) {

        }

    }

    return arr
}


// function watcher() {
//     watch(path, {filter: /\.csv$/}, function (evt, name) {
//         name=name.split('\\')
//         name=name[name.length-1]
//         console.log('%s changed.', name);
//         if (name.includes('Lp2'))
//             updateVars(name)
//
//     });
// }

async function checker() {
    let arr = []
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {
        if (!files[i].includes('Lp2'))
            continue
        arr.push(make(files[i]))
    }
    await Promise.all(arr)
    await sleep(50)
    return checker()
}

async function make(name) {
    let stats = await fs.statSync(path + name)
    let size = getSizeFromName(name)

    if (size !== stats.size) {
        console.log(name + ' changes')
        updateSizeFromName(name, stats.size)
        await updateVars(name)
    }


}


async function updateVars(name) {
    let lastFile = await fs.readFileSync(path + name, 'utf8')
    lastFile = lastFile.split('\n')
    // console.log([lastFile[lastFile.length-2]])
    let lastData = lastFile[lastFile.length - 2]
    if (lastData.includes('Buy')) {
        zignaly.exitAndCanlcelAll(longToken, 'ETHUSDT', longId)
         // zignaly.createNewOrderNew(shortToken,'ETH',shortSide,5,shortId)
    } else {

        zignaly.exitAndCanlcelAll(shortToken, 'ETHUSDT', shortId)
       //  zignaly.createNewOrderNew(longToken,'ETH',longSide,5,longId)
    }
    let data = grabData([lastData])
    //  console.log(data)

    let vars = ai.run(data, getVarsFromName(name))
    console.log('VarProfitDrawDownZeroProfit :', vars.VarProfitDrawDownZeroProfit)
    if (vars.VarProfitDrawDownZeroProfit < -1.5) {
        if (lastData.includes('Buy')) {
            //  zignaly.exitAndCanlcelAll(longToken, 'ETHUSDT', longId)
            zignaly.createNewOrderNew(shortToken, 'ETH', shortSide, 7, shortId)
        } else {

            //  zignaly.exitAndCanlcelAll(shortToken, 'ETHUSDT', shortId)
            zignaly.createNewOrderNew(longToken, 'ETH', longSide, 7, longId)
        }
    }
    // console.log(name,vars)
    updateVarsFromName(name, vars)

}


function getVarsFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].vars
}

function getSizeFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].size
}


function updateVarsFromName(name, vars) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            datas[i].vars = vars
}

function updateSizeFromName(name, size) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            datas[i].size = size
}

async function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}


