let fs = require('fs')
let _ = require('lodash')
let moment = require('moment-timezone')
run()

let adder = []


async function run() {

    let configs = await fs.readdirSync('uniq/')
    let arr = []

    let arrSide = []
    let arrRunup = []
    let total = []
    let levelPlus = []
    let types = []

    for (let i = 0; i < configs.length; i++) {


        let config = await fs.readFileSync('./uniq/' + configs[i] + '/default/compound1000.json', 'utf8')
        config = JSON.parse(config)


        for (let j = 0; j < config.length; j++) {
            total.push(config[j].total)
            let dateString = config[j].dateString.split('_')
            let runUpString = config[j].runupString.split('_')

            let arrDate = []
            for (let z = 0; z < dateString.length - 1; z++)
                arrDate.push(dateString[z])
            let sideString = config[j].sideString.split('_')
            let countOfshort = 0
            let countOfLong = 0
            for (let z = 0; z < sideString.length - 1; z++)
                if (sideString[z] === 'LONG')
                    countOfLong++
                else
                    countOfshort++
            for (let z = 0; z < runUpString.length - 1; z++)
                arrRunup.push(runUpString[z])

            add(config[j].total, arrDate, config[j].type.split('targetPercentage:false')[1])

            addShortLong(config[j].total, countOfshort, countOfLong)
            addPoftrade(config[j].total, config[j].pftrade)
            addRunup(config[j].total,arrRunup)
        }


    }

    adder = _.orderBy(adder, ['total'], ['asc']);


    for (let i = 0; i < adder.length; i++) {
        for (let z = i + 1; z < adder.length; z++) {
            add(adder[i].total, adder[z].dates)
        }
    }

    for (let i = 0; i < adder.length; i++) {
        for (let z = i + 1; z < adder.length; z++) {
            addRunup(adder[i].total, adder[z].runUp)
        }
    }

    for (let i = 0; i < adder.length; i++) {
        let countOfShort = adder[i].short
        let countOfLong = adder[i].long
        for (let z = i + 1; z < adder.length; z++) {
            countOfShort = countOfShort + adder[z].short
            countOfLong = countOfLong + adder[z].long
        }
        addShortLong(adder[i].total, countOfShort, countOfLong)
    }

    var startTime = performance.now()
    for (let i = 0; i < adder.length; i++) {
        for (let z = i + 1; z < adder.length; z++) {
            let types = adder[z].type
            for (let l = 0; l < types.length; l++)

                add(adder[i].total, null, types[l])
        }
    }

    for (let i = 0; i < adder.length; i++) {
        for (let z = i + 1; z < adder.length; z++) {
            let pfTrade = adder[z].pfTrade
            for (let l = 0; l < pfTrade.length; l++)

                addPoftrade(adder[i].total, pfTrade[l])
        }
    }

    var endTime = performance.now()
    console.log(`Call to doSomething took ${endTime - startTime} milliseconds`)


    for (let i = 0; i < adder.length; i++) {
        adder[i].dates = _.uniq(adder[i].dates)
        adder[i].dates = _.orderBy(adder[i].dates)
        adder[i].countDay = adder[i].dates.length
    }
    for (let i = 0; i < adder.length; i++) {
        adder[i].type = _.uniq(adder[i].type)
        adder[i].type = _.orderBy(adder[i].type)


        adder[i].pfTrade = _.orderBy(adder[i].pfTrade)
        adder[i].runUp = _.orderBy(adder[i].runUp)
    }

    for (let i = 0; i < adder.length; i++) {
        let dates = adder[i].dates
        let maxDiff = 0


        for (let z = 0; z < dates.length - 1; z++) {
            let diff = getDaysDiff(dates[z], dates[z + 1])
            if (diff > maxDiff)
                maxDiff = diff
        }

        adder[i].diffDay = maxDiff
    }

    for (let i = 0; i < adder.length; i++) {
        let dates = adder[i].dates
        let maxDiff = 0


        for (let z = 0; z < dates.length - 1; z++) {
            let diff = getDaysDiff(dates[z], dates[z + 1])
            if (diff > maxDiff)
                maxDiff = diff
        }

        adder[i].diffDay = maxDiff
    }


    console.log(adder)

    createConfileADV(JSON.stringify(adder, null, 2))


}


function add(total, dates, type) {
    let found = false
    for (let i = 0; i < adder.length; i++)
        if (adder[i].total === total) {
            found = true
            if (dates !== null) {
                for (let z = 0; z < dates.length; z++)
                    adder[i].dates.push(dates[z])


            }

            if (typeof type !== "undefined")
                adder[i].type.push(type)
        }

    if (found)
        return

    adder.push({total: total, dates: dates, countDay: dates.length, type: [type], pfTrade: [],runUp:[]})

}


function addShortLong(total, short, long) {
    for (let i = 0; i < adder.length; i++)
        if (adder[i].total === total) {

            adder[i].short = short
            adder[i].long = long
        }
}

function addPoftrade(total, pfTrade) {
    for (let i = 0; i < adder.length; i++)
        if (adder[i].total === total) {

            adder[i].pfTrade.push(pfTrade)

        }
}

function addRunup(total, runUp) {
    for (let i = 0; i < adder.length; i++)
        if (adder[i].total === total) {
            for (let z = 0; z < runUp.length; z++) {
                adder[i].runUp.push(runUp[z])
            }


        }
}

function getDaysDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed, 'YYYY-MM-DD').format());
    var end = moment.duration(now.diff(moment(start, 'YYYY-MM-DD')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function createfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('date.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function getDaysDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed, 'YYYY-MM-DD').format());
    var end = moment.duration(now.diff(moment(start, 'YYYY-MM-DD')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function createConfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('con3.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}