const fs = require('fs');
const csv = require('fast-csv');
let _ = require('lodash')

let ai=require('./ai')





async function parse(name,configs) {
    return new Promise(function (resolve, reject) {
        let arr = []
        fs.createReadStream('./work/'+name)
            .pipe(csv.parse({headers: true}))
            .on('error', error => reject(error))
            .on('data', row => arr.push(row))
            .on('end', rowCount => resolve(initData(arr,configs)));
    });
}


function initData(data,config) {
    // console.log(data)
    data = JSON.stringify(data)
    // data.replace(/Trade #/g, 'id').replace(/Profit %/g, 'profitPer')
    data = _.replace(data, new RegExp('Trade #', 'g'), 'id')
    data = _.replace(data, new RegExp('Profit %', 'g'), 'profit')
    data = _.replace(data, new RegExp('Run-up %', 'g'), 'runUp')
    data = _.replace(data, new RegExp('Drawdown %', 'g'), 'drawDown')
    data = _.replace(data, new RegExp('Price', 'g'), 'price')
    data = _.replace(data, new RegExp('Date/Time', 'g'), 'date')

    data = JSON.parse(data)
    // console.log(data)
    let arr = []
    for (let i = 0; i < data.length; i = i + 2) {
        if (data[i].runUp === '')
            continue
        let obj = {}
        obj.id=parseInt(data[i].id)
        obj.signal=data[i].Signal
        if (data[i].Type.includes('Long'))
            obj.side = 'LONG'
        else
            obj.side = 'SHORT'
        obj.openPrice = parseFloat(data[i].price)
        obj.closePrice=parseFloat(data[i+1].price)
        obj.openDate = data[i].date
        obj.closeDate=data[i+1].date
        obj.profit=parseFloat(data[i].profit)
        obj.runUp=parseFloat(data[i].runUp)
        obj.drawDown=parseFloat(data[i].drawDown)

        obj.drawDown = obj.drawDown * -1



        arr.push(obj)
        //  let arr=

    }

    //console.log(arr)
    let cz=[]
    for (let i=0;i<config.length;i++)
    {
        cz.push(ai.run(arr,config[i]))
    }
    return cz
}




module.exports =
    {

        parse:parse,


    }
