const fs = require('fs')
let moment = require('moment-timezone')
let _ = require('lodash')
let data='num,1,2,timeframe,pvtPeriod,atrFactor,atrPeriod,000 00:25:00.000,1,1.000,10,14,0.100,5,False,HiHi_LoLo,1.000,1.000,0.000'
init()


async function init() {






    let res = await fs.readFileSync('runres.json', 'utf8');
    res=JSON.parse(res)
    let header='RowNum,nMnTrdMethodNum,nEntSignalCodeNum,PPST1_stMnBarAge,PPST1_PvtPtPeriod,PPST1_AtrFactor,PPST1_AtrPeriod,PPST2_stMnBarAge,PPST2_PvtPtPeriod,PPST2_AtrFactor,PPST2_AtrPeriod,3crm_nStopLoss_AtrPeriod,3crm_dStopLoss_AtrRiskAdjustmentCoef,3crm_nStopLoss_SwingLookbackBarNo,3crm_bUseTrailSl,enumTrailSlRef,dTrailSlAtrMultiplier,dTpSlRewardToRiskRatio,dRrToStartTrailSl\n'

   for (let i=0;i<res.length;i++)
   {
       let t=data.replace('timeframe',res[i].timeStamp).replace('pvtPeriod',res[i].pvtPeriod).replace('atrFactor',res[i].atrFactor).replace('atrPeriod',res[i].atrPeriod).replace('num',(i+1).toString())
       if (i !== res.length-1)
           t=t+'\n'
       header=header +t
   }
    createRunResfileADV(header)

}


function getDataFromFileAndConfig(all,file,config)
{
    for (let i=0;i<all.length;i++)
    {
        // console.log(all[i].name)
        if (all[i].name ===file)
        {
            let inline=all[i].data
            for (let j=0;j<inline.length;j++)
            {
                if (inline[j].includes(config))
                    return inline[j]
            }
        }
    }
}


async function format(name) {
    let res = await fs.readFileSync('./RunRes/' + name, 'utf8');
    res = res.split('\n')
    //  console.log(res[0])
    return res
}
function createRunResfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('ymta.csv', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createFile(name, body) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('files/' + name, body, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}