const request = require('request');
let post = 'post'
let _ = require('lodash')
let auth = {Username: "AWI-236440", Password: "QVMUB653$H"}
let AvailDc = [1, 2, 3, 4, 5, 6, 7, 8]
let foundDc
let masterIp = 0
let networkId
let serverId
let initData = false

test()

async function test() {

    masterIp = '195.231.73.236'
    for (let i = 0; i < AvailDc.length; i++) {
        let servers = await getAllServers(AvailDc[i])
        servers = servers.Value
        if (servers.length === 0)
            continue

        for (let j = 0; j < servers.length; j++) {
            let server = await getDetailsofServer(AvailDc[i], servers[j].ServerId)
            server = server.Value
            console.log(masterIp)
            if (masterIp === server.NetworkAdapters[0].IPAddresses[0].Value) {
                networkId = server.NetworkAdapters[0].Id
                serverId = server.ServerId
                foundDc = AvailDc[i]
                initData = true
                break
            }

        }


    }


    console.log('foundDc ->' + foundDc)
    console.log('masterIp ->' + masterIp)
    console.log('networkId ->' + networkId)
    console.log('serverId ->' + serverId)

    let ips = await getAllIps('195.231.67.35')
    console.log(ips)

}


async function init() {
    if (initData === true)
        return true
    masterIp = getIp()
    for (let i = 0; i < AvailDc.length; i++) {

        let servers = await getAllServers(AvailDc[i])
        //console.log(servers)
        servers = servers.Value
        if (servers.length === 0)
            continue

        for (let j = 0; j < servers.length; j++) {

            let server = await getDetailsofServer(AvailDc[i], servers[j].ServerId)
            server = server.Value
            if (masterIp === server.NetworkAdapters[0].IPAddresses[0].Value) {
                networkId = server.NetworkAdapters[0].Id
                serverId = server.ServerId
                foundDc = AvailDc[i]
                initData = true
                break
            }

        }


    }
    console.log('foundDc ->' + foundDc)
    console.log('masterIp ->' + masterIp)
    console.log('networkId ->' + networkId)
    console.log('serverId ->' + serverId)

    return true
}


async function getAllServers(dc) {
    let url = generateUrl(dc, 'GetServers')

    let d = await doRequest(url, auth)

    return d
}

async function getDetailsofServer(dc, id) {
    let url = generateUrl(dc, 'GetServerDetails')

    let body = auth
    body.ServerId = id
    let d = await doRequest(url, body)

    return d
}

async function createFloatingIp() {
    let ips = await getAllIps()
    let url = generateUrl(foundDc, 'SetPurchaseIpAddress')

    let d = await doRequest(url, auth)
    d = d.Value
    await attachedToServer(foundDc, d.ResourceId)
    return d
}

async function getAllIps() {
    let url = generateUrl(foundDc, 'GetPurchasedIpAddresses')

    let d = await doRequest(url, auth)
    let arr = []
    d = d.Value
    for (let i = 0; i < d.length; i++) {
        if (d[i].Value !== masterIp && d[i].ServerId === serverId)
            arr.push(d[i])
    }

    return arr
}

async function canAddFloatingIp() {
    let ips = await getAllIps()
    let count = 0
    for (let i = 0; i < ips.length; i++) {

    }
}


async function deleteAllIps() {

    let ips = await getAllIps(foundDc)
    for (let i = 0; i < ips.length; i++) {
        if (ips[i].Value !== masterIp) {
            let d = await deleteIp(foundDc, ips[i].ResourceId)
            // console.log(d)
        }

    }


    return 'Done'
}


async function attachedToServer(resourceId) {
    let url = generateUrl(foundDc, 'SetEnqueueAssociateIpAddress')

    let body = auth
    body.IpRequest = {NetworkAdapterId: networkId, IpAddressResourceIds: [resourceId]}
    let d = await doRequest(url, body)

    return d


}


async function unAttachedToServer(resourceId) {
    let url = generateUrl(foundDc, 'SetEnqueueDeassociateIpAddress')

    let body = auth
    body.IpRequest = {NetworkAdapterId: networkId, IpAddressResourceIds: [resourceId]}
    let d = await doRequest(url, body)

    return d


}

function getDc() {
    return foundDc
}


async function attachedToServerByIp(ip) {
    let ips = await getAllIps(foundDc)

    for (let i = 0; i < ips.length; i++) {
        if (ips[i].Value === ip) {
            //  console.log(ips[i])
            await attachedToServer(foundDc, ips[i].ResourceId)
            break
        }
    }


    return 'Done'


}


async function RemovedByIp(ip) {
    let ips = await getAllIps(foundDc)

    for (let i = 0; i < ips.length; i++) {
        if (ips[i].Value === ip && ip !== masterIp) {
            return await deleteIp(foundDc, ips[i].ResourceId)

        }
    }


}

async function deleteIp(id) {
    try {
        await unAttachedToServer(foundDc, id)
    } catch (e) {

    }

    let url = generateUrl(foundDc, 'SetRemoveIpAddress')
    let body = auth
    body.IpAddressResourceId = id
    let d = await doRequest(url, body)

    return d

}


async function doRequest(url, body) {


    var options = {
        method: post,
        url: url,
        timeout: 20000,
        headers:
            {
                'Content-Type':
                    'application/json'
            }
        ,
        body: JSON.stringify(body)

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {

            if (error) reject('Problem ->' + options.url)
            try {

                resolve(JSON.parse(body))

            } catch (e) {
                console.log(e)
                resolve(true)
                //  console.log('Problem --->' + options.url)
                // console.log(e)

            }

        });
    });
}


async function doLocalRequest(mainIp, addIp) {


    let base = 'http://' + mainIp + ':3000/ip/' + addIp
    console.log(base)
    var options = {
        method: 'get',
        url: base,
        timeout: 20000,
        headers: {
            'accept': 'application/json',
            'Authorization': 'Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXUyJ9.eyJjbGllbnRfaWQiOjYxMTYxLCJpYXQiOjE1NzUyNDM0MDR9.s0l_J_EIvcgWbvQHXwrS3h3I8CY0pkdsWux0O1pUwTo'
        }

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {
            if (error) reject('Problem With Request Cherry Servers')
            try {


                resolve(true)

            } catch (e) {
                resolve(true)
                //  console.log('Problem --->' + options.url)
                // console.log(e)

            }

        });
    });
}

function generateUrl(dc, endpoint) {
    return 'https://api.dc' + dc + '.computing.cloud.it/WsEndUser/v2.9/WsEndUser.svc/json/' + endpoint
}


function getIp() {
    const ni = require('network-interfaces');

    const options = {
        internal: false, // boolean: only acknowledge internal or external addresses (undefined: both)
        ipVersion: 4     // integer (4 or 6): only acknowledge addresses of this IP address family (undefined: both)
    };

    const ip = ni.toIp('eth0', options);
    return ip

}

function logData() {
    console.log('foundDc ->' + foundDc)
    console.log('masterIp ->' + masterIp)
    console.log('networkId ->' + networkId)
    console.log('serverId ->' + serverId)
}

module.exports =
    {
        init: init,
        getAllIps: getAllIps,
        attachedToServerByIp: attachedToServerByIp,
        RemovedByIp: RemovedByIp,
        getDc: getDc,
        logData: logData,
        createFloatingIp: createFloatingIp


    }
