const HetznerCloud = require('hcloud-js')
let client
let _ = require('lodash')

class Hetzner {


    constructor(token) {

        client = new HetznerCloud.Client(_.trim(token))
    }


    getAllServers() {
        return new Promise(function (resolve, reject) {

            client.servers.list().then(function (res) {
                // console.log(res)
                let d = _.values(res.servers);
                resolve(d)

            })
        })


    }


    getAllFloatingIps() {
        return new Promise(function (resolve, reject) {

            client.floatingIPs.list().then(function (res) {

                let d = _.values(res.floatingIPs);

                resolve(d)

            })
        })


    }


    async deleteServer(id) {
        return new Promise(function (resolve, reject) {

            client.servers.delete(id).then(function (res) {
                resolve(res)
            })
        })
    }

    async delFloatingIp(id) {
        return new Promise(function (resolve, reject) {

            client.floatingIPs.delete(id).then(function (res) {
                resolve(res)
            })
        })
    }

    async removeByIp(ip) {
        try {
            ip = _.trim(ip)
            console.log('try to remove ip:' + ip)
            let servers = await this.getAllServers()
            for (let i = 0; i < servers.length; i++) {
                if (ip === servers[i].publicNet.server.publicNet.ipv4.ip) {

                    await this.deleteServer(servers[i].id)
                }


            }
        } catch (e) {

        }
        return true

    }



    async removeFloatingIpByIp(ip) {
        try {
            ip = _.trim(ip)
            console.log('try to remove ip:' + ip)
            let ips = await this.getAllFloatingIps()
            for (let i = 0; i < ips.length; i++) {
                if (ip === ips[i].ip) {

                    await this.delFloatingIp(ips[i].id)
                }


            }
        } catch (e) {

        }
        return true

    }


    async removeAllFloatingIps() {
        try {


            let ips = await this.getAllFloatingIps()
            for (let i = 0; i < ips.length; i++) {


                    await this.delFloatingIp(ips[i].id)



            }
        } catch (e) {

        }
        return true

    }


    async getMasterServerId() {
        try {


            let servers = await this.getAllServers()


            for (let i = 0; i < servers.length; i++) {
                if (servers[i].name === 'master') {

                    return servers[i].id
                }


            }
        } catch (e) {

        }
        return true

    }





    createServer(name) {

        // nuremberg nbg1
        //fsn1

        return new Promise(function (resolve, reject) {
            client.servers.build(name)
                .serverType('cx51-ceph')
                .location('fsn1')
                .image('9541194')
                .sshKey('ffgf')
                .create()
                .then(function (response) {
                    resolve(response)
                })
                .catch(function (error) {
                    // Handle error...
                })
        })

    }


    createFloatingIp(location, server) {

        // nuremberg nbg1
        //fsn1

        return new Promise(function (resolve, reject) {
            client.floatingIPs.build()
                .type('ipv4')
                .location(location)
                .server(server)
                .create()
                .then(function (response) {

                    resolve(response.floatingIP.ip)
                })
                .catch(function (error) {
                    resolve(false)
                })
        })

    }


}


module.exports = Hetzner;
