const request = require('request');
let post = 'post'
let _ = require('lodash')
let auth = {Username: "AWI-236440", Password: "QVMUB653$H"}
let ip
let AvailDc = [1, 2, 3, 4,  6, 7, 8]
let foundDc
let masterIp
let networkId
let serverId

//test()

async function test() {


    await deleteAllIps(1)

}


async function init() {
    ip = await getIp()
    for (let i = 0; i < AvailDc.length; i++) {
        let servers = await getAllServers(AvailDc[i])
        servers = servers.Value
        if (servers.length === 0)
            continue

        for (let j = 0; j < servers.length; j++) {

            let server = await getDetailsofServer(AvailDc[i], servers[j].ServerId)
            server = server.Value
            if (ip === server.NetworkAdapters[0].IPAddresses[0].Value) {
                masterIp = server.NetworkAdapters[0].IPAddresses[0].Value
                networkId = server.NetworkAdapters[0].Id
                serverId = server.ServerId
                foundDc = AvailDc[i]
                break
            }

        }


    }
}


async function getAllServers(dc) {
    let url = generateUrl(dc, 'GetServers')

    let d = await doRequest(url, auth)

    return d
}

async function getDetailsofServer(dc, id) {
    let url = generateUrl(dc, 'GetServerDetails')

    let body = auth
    body.ServerId = id
    let d = await doRequest(url, body)

    return d
}

async function createFloatingIp(dc) {
    let url = generateUrl(foundDc, 'SetPurchaseIpAddress')

    let d = await doRequest(url, auth)
    d = d.Value
    await attachedToServer(foundDc, d.ResourceId)
    return d
}

async function getAllIps(dc) {
    let url = generateUrl(foundDc, 'GetPurchasedIpAddresses')

    let d = await doRequest(url, auth)

    let arr = []
    d = d.Value
    for (let i = 0; i < d.length; i++) {
        if (d[i].Value !== masterIp)
            arr.push(d[i])
    }

    return arr
}

async function deleteAllIps(dc) {
    let ips = await getAllIps(foundDc)
    for (let i = 0; i < ips.length; i++) {
        if (ips[i].Value !== masterIp) {
            let d = await deleteIp(foundDc, ips[i].ResourceId)
            console.log(d)
        }

    }


    return 'Done'
}


async function attachedToServer(dc, resourceId) {
    let url = generateUrl(foundDc, 'SetEnqueueAssociateIpAddress')

    let body = auth
    body.IpRequest = {NetworkAdapterId: networkId, IpAddressResourceIds: [resourceId]}
    let d = await doRequest(url, body)

    return d


}


async function unAttachedToServer(dc, resourceId) {
    let url = generateUrl(foundDc, 'SetEnqueueDeassociateIpAddress')

    let body = auth
    body.IpRequest = {NetworkAdapterId: networkId, IpAddressResourceIds: [resourceId]}
    let d = await doRequest(url, body)

    return d


}


async function attachedToServerByIp(dc, ip) {
    let ips = await getAllIps(foundDc)

    for (let i = 0; i < ips.length; i++) {
        if (ips[i].Value === ip) {
            await attachedToServer(foundDc, ips[i].ResourceId)
            break
        }
    }


    return 'Done'


}


async function RemovedByIp(dc, ip) {
    let ips = await getAllIps(dc)

    for (let i = 0; i < ips.length; i++) {
        if (ips[i].Value === ip && ip !==masterIp) {
            await deleteIp(foundDc, ips[i].ResourceId)
            break
        }
    }


    return 'Done'


}

async function deleteIp(dc, id) {
    await unAttachedToServer(foundDc, id)
    let url = generateUrl(foundDc, 'SetRemoveIpAddress')
    let body = auth
    body.IpAddressResourceId = id
    let d = await doRequest(url, body)

    return d

}


function getDc() {
    return foundDc
}


async function doRequest(url, body) {


    var options = {
        method: post,
        url: url,
        timeout: 20000,
        headers:
            {
                'Content-Type':
                    'application/json'
            }
        ,
        body: JSON.stringify(body)

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {

            if (error) reject('Problem ->' + options.url)
            try {


                resolve(JSON.parse(body))

            } catch (e) {
                resolve(true)
                //  console.log('Problem --->' + options.url)
                // console.log(e)

            }

        });
    });
}


async function doLocalRequest(mainIp, addIp) {


    let base = 'http://' + mainIp + ':3000/ip/' + addIp
    console.log(base)
    var options = {
        method: 'get',
        url: base,
        timeout: 20000,
        headers: {
            'accept': 'application/json',
            'Authorization': 'Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXUyJ9.eyJjbGllbnRfaWQiOjYxMTYxLCJpYXQiOjE1NzUyNDM0MDR9.s0l_J_EIvcgWbvQHXwrS3h3I8CY0pkdsWux0O1pUwTo'
        }

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {
            if (error) reject('Problem With Request Cherry Servers')
            try {


                resolve(true)

            } catch (e) {
                resolve(true)
                //  console.log('Problem --->' + options.url)
                // console.log(e)

            }

        });
    });
}

function generateUrl(dc, endpoint) {
    return 'https://api.dc' + dc + '.computing.cloud.it/WsEndUser/v2.9/WsEndUser.svc/json/' + endpoint
}

function getIp() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/getIp/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}

module.exports =
    {
        init: init,
        getAllIps: getAllIps,
        getDc: getDc,
        attachedToServerByIp: attachedToServerByIp,
        RemovedByIp: RemovedByIp,
        createFloatingIp: createFloatingIp


    }
